<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps
// where controller filters or CSRF protection are bypassed.
// If you don't want to define all routes, please use the Auto Routing (Improved).
// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.
// $routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Home::index');
$routes->get('/index', 'Home::index');
$routes->get('/register', 'Home::register');
$routes->get('/login', 'Login::login');
$routes->post('/register', 'Home::post_register');
$routes->post('/login', 'Login::auth');
$routes->get('/logout', 'Login::logout');
$routes->get('/personal', 'Home::personal');
$routes->post('/personal', 'Home::post_personal');
$routes->get('/garantor', 'Home::garantor');
$routes->post('/garantor', 'Home::post_garantor');
$routes->get('/loanrequest', 'Home::loanrequest');
$routes->post('/loanrequest', 'Home::post_loanrequest');
$routes->get('/loanpayment', 'Home::loanpayment');
$routes->post('/deposit', 'Mpesa::deposit');
$routes->get('/paymentconfirmation', 'Mpesa::paymentconfirmation');
$routes->get('/paymentsuccess', 'Mpesa::paymentsuccess');
$routes->post('/paymentcheck', 'Mpesa::paymentcheck');
$routes->get('/mpesatransactions', 'Home::mpesatransactions');
$routes->get('/loanshistory', 'Home::loanshistory');
$routes->get('/accounts', 'Home::accounts');
$routes->get('/privacy', 'Home::privacy');
$routes->get('/editpersonal', 'Home::editpersonal');
$routes->post('/editpersonal', 'Home::post_editpersonal');

$routes->get('/about', 'Home::about');


/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
